#ifndef __I_DATA_STREAM_H__
#define __I_DATA_STREAM_H__

/***** IDataStream ************************************************************
 *	
 *	IDataStream is a generalized I/O class which can provide support for
 *	any type of I/O.
 *	
 *	To use it:
 *		Derive your own class for new I/O types. You don't need specific
 *		handlers for reading/writing anything other than a buffer; this base
 *		class will automatically fall back on general functions if none are
 *		provided.
 *
 *****  2001 Ian Patterson **************************************************/

class IDataStream
{
	public:
						IDataStream();
		virtual			~IDataStream();
		
		virtual UInt32	GetLength(void) = 0;
		virtual UInt32	GetRemaining(void) = 0;
		
		virtual UInt8	HitEOF(void) = 0;
		
		virtual UInt32	GetPosition(void) = 0;
		virtual void	SetPosition(UInt32 position) = 0;
		virtual void	Skip(UInt32 numToSkip) = 0;
		
		virtual UInt8	ReadChar(void)		{ UInt8  data; ReadBuffer((UInt8 *)&data, 1); return data; }
		virtual UInt16	ReadShort(void)		{ UInt16 data; ReadBuffer((UInt8 *)&data, 2); return data; }
		virtual UInt32	ReadLong(void)		{ UInt32 data; ReadBuffer((UInt8 *)&data, 4); return data; }
		
		virtual UInt16	ReadIntelShort(void);
		virtual UInt32	ReadIntelLong(void);
		
		virtual void	ReadString(char * buf, UInt32 maxLength);
		virtual void	ReadPCString(char * buf, UInt32 maxLength);
		virtual void	ReadMacString(char * buf, UInt32 maxLength);
		virtual void	ReadUnixString(char * buf, UInt32 maxLength);
		virtual void	ReadUnknownString(char * buf, UInt32 maxLength);
		
		virtual void	ReadBuffer(UInt8 * buf, UInt32 length) = 0;
		
		virtual void	WriteChar(UInt8 data)	{ WriteBuffer((UInt8 *)&data, 1); }
		virtual void	WriteShort(UInt16 data)	{ WriteBuffer((UInt8 *)&data, 2); }
		virtual void	WriteLong(UInt32 data)	{ WriteBuffer((UInt8 *)&data, 4); }
		
		virtual void	WriteIntelShort(UInt16 data);
		virtual void	WriteIntelLong(UInt32 data);
		
		virtual void	WriteString(char * buf) { WriteBuffer((UInt8 *)buf, std::strlen(buf) + 1); }
		virtual void	WritePCString(char * buf);
		virtual void	WriteMacString(char * buf);
		virtual void	WriteUnixString(char * buf);
		
		virtual void	WriteBuffer(UInt8 * buf, UInt32 length) = 0;
		
		virtual UInt8	DoesAutoResize(void) = 0;
};

#endif /* __I_DATA_STREAM_H__ */